/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.LightWeightCanvas;
import com.ibm.hsc.common.util.TextWrapper;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;

public class MultiLineTextLabel
extends LightWeightCanvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected TextWrapper wrapper;
    protected String text = null;
    protected int alignment = 0;
    protected int maxWidth;
    protected Locale locale;
    protected Insets insets;

    public MultiLineTextLabel(int n, Locale locale) {
        this.maxWidth = n;
        this.locale = locale;
        this.insets = new Insets(5, 5, 5, 5);
        this.wrapper = new TextWrapper(this.text, n, null, locale);
    }

    public void paint(Graphics graphics) {
        Font font = this.getFont();
        graphics.setFont(font);
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = this.getSize();
        int n = fontMetrics.getHeight();
        int n2 = dimension.width - this.insets.left - this.insets.right;
        int n3 = this.insets.top;
        int n4 = this.insets.left;
        this.wrapper.setFontMetrics(fontMetrics);
        if (this.alignment == 0) {
            this.wrapper.paintLeftJustified(graphics, n4, n3);
        } else if (this.alignment == 2) {
            this.wrapper.paintRightJustified(graphics, n4, n3, n2);
        } else {
            this.wrapper.paintCentered(graphics, n4, n3, n2);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                this.repaint();
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + n);
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        if (!(string == this.text || this.text != null && this.text.equals(string))) {
            this.text = string;
            this.wrapper.setText(string);
            this.invalidate();
        }
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.wrapper.setFontMetrics(fontMetrics);
        Dimension dimension = this.wrapper.getPreferredSize();
        dimension.width += this.insets.left + this.insets.right;
        dimension.height += this.insets.top + this.insets.bottom;
        return dimension;
    }

    public void adjustWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.wrapper.setFontMetrics(fontMetrics);
        this.maxWidth = Math.max(this.maxWidth, this.wrapper.getMinimumWidth());
    }

    public void setWidth(int n) {
        this.maxWidth = n;
    }

    public int getWidth() {
        return this.maxWidth;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }
}

